#include <stdio.h>
#include <string.h>

struct Student {
    int id;
    char name[50];
    int age;
    char address[100];
};

struct Student students[20];
int numberOfStudents = 0;

void addStudents(int inputs) {
    for (int i = 0; i < inputs; i++) {
        printf("Enter details for student %d:\n", i + 1);
        printf("ID: ");
        scanf("%d", &students[i].id);
        getchar(); // Clear the input buffer for unwanted /n
        printf("Name: ");
        fgets(students[i].name, 50, stdin);
        printf("Address: ");
        fgets(students[i].address, 100, stdin);
        printf("Age: ");
        scanf("%d", &students[i].age);
        
    }
    numberOfStudents += inputs;
}

struct Student findStudent(int id) {
    struct Student student;
    
    for (int i = 0; i < numberOfStudents; i++) {
        if (students[i].id == id) {
            student = students[i];
            return student;
        }
    }

    printf("Student with ID %d not found.\n", id);
    student.id = id;
    strcpy(student.name, "Not found");
    return student;
}

void printStudentDetails(struct Student student) {
    printf("ID: %d\n", student.id);
    printf("Name: %s\n", student.name);
    printf("Age: %d\n", student.age);
    printf("Address: %s\n", student.address);
}

void main() {
    do{
        printf("\n\nSelect one of the following options:\n 1. Add students information\n 2. Find and show student details\n 3. Exit\n Option:");
        int option;
        scanf("%d", &option);
        switch (option) {
            case 1:
                int inputs;
                printf("Enter number of students: ");
                scanf("%d", &inputs);
                addStudents(inputs);
                break;
            case 2:
                int id;
                printf("Enter student ID: ");
                scanf("%d", &id);
                struct Student student = findStudent(id);
                printStudentDetails(student);
                break;
            case 3:
                return;
        }
    } while (1);
}
